/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.json;

import com.eclipsesource.json.Json$DefaultHandler;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonLiteral;
import com.eclipsesource.json.JsonNumber;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonParser;
import com.eclipsesource.json.JsonString;
import com.eclipsesource.json.JsonValue;
import java.io.Reader;

public final class Json {
    public static final JsonValue NULL = new JsonLiteral("null");
    public static final JsonValue TRUE = new JsonLiteral("true");
    public static final JsonValue FALSE = new JsonLiteral("false");

    private Json() {
    }

    public static JsonValue value(int n) {
        return new JsonNumber(Integer.toString(n, 10));
    }

    public static JsonValue value(long l) {
        return new JsonNumber(Long.toString(l, 10));
    }

    public static JsonValue value(float f) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Json.cutOffPointZero(Float.toString(f)));
    }

    public static JsonValue value(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Json.cutOffPointZero(Double.toString(d)));
    }

    public static JsonValue value(String string) {
        return string == null ? NULL : new JsonString(string);
    }

    public static JsonValue value(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static JsonArray array() {
        return new JsonArray();
    }

    public static JsonArray array(int ... nArray) {
        if (nArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (int n : nArray) {
            jsonArray.add(n);
        }
        return jsonArray;
    }

    public static JsonArray array(long ... lArray) {
        if (lArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (long l : lArray) {
            jsonArray.add(l);
        }
        return jsonArray;
    }

    public static JsonArray array(float ... fArray) {
        if (fArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (float f : fArray) {
            jsonArray.add(f);
        }
        return jsonArray;
    }

    public static JsonArray array(double ... dArray) {
        if (dArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (double d : dArray) {
            jsonArray.add(d);
        }
        return jsonArray;
    }

    public static JsonArray array(boolean ... blArray) {
        if (blArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (boolean bl : blArray) {
            jsonArray.add(bl);
        }
        return jsonArray;
    }

    public static JsonArray array(String ... stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (String string : stringArray) {
            jsonArray.add(string);
        }
        return jsonArray;
    }

    public static JsonObject object() {
        return new JsonObject();
    }

    public static JsonValue parse(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        Json$DefaultHandler json$DefaultHandler = new Json$DefaultHandler();
        new JsonParser(json$DefaultHandler).parse(string);
        return json$DefaultHandler.getValue();
    }

    public static JsonValue parse(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        Json$DefaultHandler json$DefaultHandler = new Json$DefaultHandler();
        new JsonParser(json$DefaultHandler).parse(reader);
        return json$DefaultHandler.getValue();
    }

    private static String cutOffPointZero(String string) {
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }
}

